import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import axios from "axios";
import { BASE_URL } from "../../../config/service";
import { formatDateForUI } from "../../../data/global";


const INITIAL_STATE = {
    isLoading: false,
    services: [],
    servicesPages: []
}

const ServicesSlice = createSlice({
    initialState: INITIAL_STATE,
    name: 'services',
    reducers: {},
    extraReducers: (builder) => {
        builder.addCase(GetAllServicesPages.pending, (state) => {
            state.isLoading = true
        })
        builder.addCase(GetAllServicesPages.fulfilled, (state, action) => {
            state.isLoading = false
            state.servicesPages = action.payload?.data.map((item) => [item.id, item.template_value, item.route_url, formatDateForUI(item?.created_at), item])
        })
        builder.addCase(GetAllServicesPages.rejected, (state, action) => {
            state.isLoading = false
        })
    }
})

export default ServicesSlice.reducer


// login

export const LogInAction = createAsyncThunk('/auth/logoin/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        }
        const response = await axios.post(`${BASE_URL}/login`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const SignUpAction = createAsyncThunk('/auth/signup/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        }
        const response = await axios.post(`${BASE_URL}/signup`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

// Upload Service Media
export const UploadServiceMediaAction = createAsyncThunk('/services/upload-media/POST', async (payload, { rejectWithValue, getState }) => {
    try {
        const state = getState();
        const token = localStorage.getItem('token'); // Adjust based on your auth state structure

        if (!token) {
            return rejectWithValue('No authorization token found');
        }

        const headers = {
            'Authorization': `Bearer ${token}`,
            'Accept': 'application/json'
        }

        const formData = new FormData();
        formData.append('file', payload.file);

        const response = await axios.post(`${BASE_URL}/services-detail-media`, formData, { headers });
        return response.data;
    } catch (error) {
        return rejectWithValue(error.response?.data?.message || 'Failed to upload service media');
    }
})



export const SaveWebDevTemplatePage = createAsyncThunk('/web-development-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/web-development-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const SaveBrandAgencyTemplatePage = createAsyncThunk('/brand-agency-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/brand-agency-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const SaveGraphicDesignTemplatePage = createAsyncThunk('/graphic-design-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/graphic-design-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateGraphicDesignTemplatePage = createAsyncThunk('/graphic-design-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/graphic-design-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateWebDevTemplatePage = createAsyncThunk('/web-development-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/web-development-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateBrandAgencyTemplatePage = createAsyncThunk('/brand-agency-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/brand-agency-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateSoftDevTemplatePage = createAsyncThunk('/software-development-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/software-development-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateWebsiteDesignTemplatePage = createAsyncThunk('/website-design-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/website-design-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})
export const UpdateAppDevTemplatePage = createAsyncThunk('/application-development-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/application-development-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateVirtualEmployTemplatePage = createAsyncThunk('/virtual-employees-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/virtual-employees-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateReputationManagementTemplatePage = createAsyncThunk('/reputation-management-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/reputation-management-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})
export const UpdateInternetMarkettingTemplatePage = createAsyncThunk('/internet-marketing-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/internet-marketing-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateListingServiceTemplatePage = createAsyncThunk('/listing-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/listing-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateContentMarkettingTemplatePage = createAsyncThunk('/content-marketing-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/content-marketing-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateEmailMarkettingTemplatePage = createAsyncThunk('/email-marketing-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/email-marketing-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateSearchEngineMarkettingTemplatePage = createAsyncThunk('/search-engine-marketing-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/search-engine-marketing-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateEcommerceMarkettingTemplatePage = createAsyncThunk('/ecommerce-marketing-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/ecommerce-marketing-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const UpdateSocialMediaMarkettingTemplatePage = createAsyncThunk('/social-media-marketing-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/social-media-marketing-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})
export const UpdateSeoServiceTemplatePage = createAsyncThunk('/seo-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/seo-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})
export const UpdateDigitalMarkettingTemplatePage = createAsyncThunk('/digital-marketing-service-template/patch', async ({ id, data }, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        // const { id, ...updateData } = payload;
        const response = await axios.patch(`${BASE_URL}/digital-marketing-service-template/${id}`, data, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const SaveSoftwareDevTemplatePage = createAsyncThunk('/software-development-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/software-development-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const SaveWebsiteDesignTemplatePage = createAsyncThunk('/website-design-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/website-design-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})


export const SaveAppDevTemplatePage = createAsyncThunk('/application-development-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/application-development-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})


export const SaveVirtualEmployTemplatePage = createAsyncThunk('/virtual-employees-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/virtual-employees-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})


export const SaveReputationManagementTemplatePage = createAsyncThunk('/reputation-management-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/reputation-management-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})


export const SaveInternetMarketingTemplatePage = createAsyncThunk('/internet-marketing-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/internet-marketing-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})


export const SaveListingTemplatePage = createAsyncThunk('/listing-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/listing-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const SaveContentMarketingTemplatePage = createAsyncThunk('/content-marketing-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/content-marketing-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const SaveEmailMarketingTemplatePage = createAsyncThunk('/email-marketing-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/email-marketing-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const SaveSearchEngineMarketingTemplatePage = createAsyncThunk('/search-engine-marketing-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/search-engine-marketing-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const EcommerceMarketingTemplatePage = createAsyncThunk('/ecommerce-marketing-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/ecommerce-marketing-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})


export const SocialMediaMarketingTemplatePage = createAsyncThunk('/social-media-marketing-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/social-media-marketing-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const SeoTemplatePage = createAsyncThunk('/seo-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/seo-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const SaveDigitalMarketingTemplatePage = createAsyncThunk('/digital-marketing-service-template/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.post(`${BASE_URL}/digital-marketing-service-template`, payload, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})

export const GetAllServicesPages = createAsyncThunk('/pages-info/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${localStorage.getItem('token')}`
        }
        const response = await axios.get(`${BASE_URL}/pages-info`, { headers });
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }
})