import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import axios from "axios";
import { BASE_URL } from "../../../config/service";


const INITIAL_STATE = {
    isLoading: false,
}

const AuthSlice = createSlice({
    initialState: INITIAL_STATE,
    name: 'auth',
    reducers: {},
})

export default AuthSlice.reducer


// login

export const LogInAction = createAsyncThunk('/auth/logoin/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        }
        const response = await axios.post(`${BASE_URL}/login`, payload, headers);
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }   
})

export const SignUpAction = createAsyncThunk('/auth/signup/POST', async (payload, { rejectWithValue }) => {
    try {
        const headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        }
        const response = await axios.post(`${BASE_URL}/signup`, payload, headers);
        return response.data
    } catch (error) {
        return rejectWithValue(error.response.data.message || 'Invalid Credentials')
    }   
})