import React from 'react'
import { Route, Routes } from 'react-router-dom'
import Login from '../components/pages/Login/Login'
import Dashboard from '../components/pages/Dashboard/Dashboard'
import Error from '../components/Error/Error'
import Leads from '../components/pages/Property/Leads'
import LeadSources from '../components/pages/Property/LeadsSources'
import LeadsDetail from '../components/pages/Property/LeadsDetail'
import LeadTypes from '../components/pages/Property/LeadsTypes'
import AllAdminUsers from '../components/pages/Property/AllAdminUsers'
import Roles from '../components/pages/Roles/Roles'
import UserProfile from '../components/pages/Property/UserProfile/UserProfile'
import EditProfile from '../components/pages/Property/UserProfile/EditProfile'
import FAQSection from '../components/FAQ/FAQ'
import SignUp from '../components/pages/Login/SignUp'
import AddBlogPost from '../components/pages/Property/AddBlogPost'
import BlogsPage from '../components/pages/Property/Leads'
import HomePage from '../components/pages/Property/HomePage'
import HomeMainBanners from '../components/pages/Property/HomeMainBanners'
import Services from '../components/pages/Property/Services'
import Achievements from '../components/pages/Property/Achievements'
import ServicesTabs from '../components/pages/Property/ServicesTabs'
import PortfolioListing from '../components/pages/Property/PortfolioListing'
import FaqListing from '../components/pages/Property/FaqListing'
import Promotions from '../components/pages/Property/Promotions'
import ReviewsListing from '../components/pages/Property/ReviewsListing'
import ServicesPages from '../components/pages/Property/ServicesPages'

const Router = () => {
    return (
        <>
            <Routes>
                <Route path='/' element={<Login />} />
                <Route path='/signup' element={<SignUp />} />
                <Route path='/dashboard' element={<Dashboard />} >  
                    <Route path='home' element={<HomePage />} />
                    <Route path='banners' element={<HomeMainBanners />} />
                    <Route path='blogs' element={<BlogsPage />} />
                    <Route path='blogs/:id' element={<LeadsDetail />} />
                    <Route path='blog-category' element={<LeadSources />} />
                    <Route path='blog-post' element={<LeadTypes />} />
                    <Route path='blog-post/add' element={<AddBlogPost />} />
                    <Route path='blog-post/edit/:id' element={<AddBlogPost />} />
                    <Route path='profile/view/:id' element={<UserProfile />} />
                    <Route path='profile/edit/:id' element={<EditProfile />} />
                    <Route path='users' element={<AllAdminUsers />} />
                    <Route path='roles' element={<Roles />} />
                    <Route path='faq' element={<FAQSection />} />
                    <Route path='achievements' element={<Achievements />} />
                    <Route path='promotions' element={<Promotions />} />
                    <Route path='reviews' element={<ReviewsListing />} />
                    <Route path='portfolio' element={<PortfolioListing />} />
                    <Route path='faqs' element={<FaqListing />} />
                    <Route path='services' element={<Services />} />
                    <Route path='services-tabs' element={<ServicesTabs />} />
                    <Route path='services-pages' element={<ServicesPages />} />
                </Route>
                <Route path='*' element={<Error />} />
            </Routes>
        </>
    )
}

export default Router