import { useEffect, useState } from 'react'
import { useLocation, useNavigate } from 'react-router-dom';
import { useModal } from '../../../hooks/useModal';
import { MAIN_HEADINGS } from '../../../data';
import { FaPlus } from 'react-icons/fa6';
import Button from '../../ModalButton/Button';
import { Badge, Col, OverlayTrigger, Row, Tooltip } from 'react-bootstrap';
import DataGridGlobal from '../../MUI/DataGrid/DataGridGlobal';
import ModalGlobal from '../../MUI/Modal/ModalGlobal';
import IconMenu from '../../MUI/IconMenu/IconMenu';
import { useDispatch, useSelector } from 'react-redux';
import { DeleteLeadSource, DeleteLeadType, DeletePropertyTypes, GetBlogPosts, GetLeadType, GetPropertyTypes } from '../../../store/slices/propertyManagementSlice/propertyManagementSlice';
import AddPropertyType from './AddPropertyType';
import MapLoader from '../../Loader/MapLoader';
import { errorNotify } from '../../../Toastify/Toastify';
import { formatDateForUI } from '../../../data/global';
import AddSource from './AddSource';
import AddLeadType from './AddLeadType';
import { RxQuestionMarkCircled } from "react-icons/rx";


const LeadTypes = () => {
    const [isEdit, setIsEdit] = useState(false)
    const [document, setDocument] = useState(false)
    const dispatch = useDispatch();
    const { isLoading, blogPosts } = useSelector((state) => state.PropertyMangementReducer)
    useEffect(() => {
        dispatch(GetBlogPosts())
    }, [])
    const { pathname } = useLocation();
    const { handleModalOpen } = useModal()        // this is my custom hook to work with Modal globally
    const navigate = useNavigate()

    const columns = [
        {
            name: 'id',
            label: "SNO",
            options: {
                filter: false,
                customBodyRender: (value) => (
                    <div className='ms-4'>{value}</div>
                )
            }
        },
        {
            name: 'title',
            label: "Title",
            options: {
                customBodyRender: (value) => (
                    <div className='ms-4'>{value}</div>
                )
            }
        },
        {
            name: 'slug',
            label: "Slug",
            options: {
                customBodyRender: (value) => (
                    <div className='ms-4'>{value}</div>
                )
            }
        },
        {
            name: 'category_id',
            label: "Category",
            options: {
                customBodyRender: (value) => (
                    <div className='ms-4'>{value}</div>
                )
            }
        },
        {
            name: 'is_featured',
            label: "Featured",
            options: {
                customBodyRender: (value) => (
                    <div className='ms-4'>{value ? <Badge bg="success" style={{ fontSize: 13 , padding:'8px 15px' }}>Yes</Badge> : <Badge bg="danger" style={{ fontSize: 13 , padding:'8px 15px' }}>No</Badge>}</div> // want to show badge here
                    
                )
            }
        },
        {
            name: 'is_active',
            label: "Active",
            options: {
                customBodyRender: (value) => (
                    <div className='ms-4'>{value ? <Badge bg="primary" style={{ fontSize: 13 , padding:'8px 15px' }}>Active</Badge> : <Badge bg="warning" style={{ fontSize: 13 , padding:'8px 15px' }}>Inactive</Badge>}</div> // want to show badge here

                )
            }
        },

        {
            name: 'Date',
            label: "Date",
            options: {
                customBodyRender: (value) => (
                    <div className='ms-4'>{value}</div>
                )
            }
        },

        {
            label: "Actions",
            name: 'actions',
            options: {
                filter: false,
                customBodyRender: (value) => (
                    <div className='ms-4'> <IconMenu options={["Edit", "Delete"]} onEditHandler={() => editHandler(value)}
                        onDeleteHandler={() => deleteHandler(value)} /></div>
                ),

            }
        },
    ];

    const data = [
        ["61", "Al Mouj, Muscat", "test", "test", "test", "test", "123456789", "Mr Test"],
        ["62", "Al Mouj2, Muscat2", "test2", "test2", "test2", "test2", "1234567892", "Mr Test2"],

    ];

    const options = {
        elevation: 1,
        rowsPerPage: 10,
        rowsPerPageOptions: [10, 15, 20],
        filterType: "dropdown",
    };

    const editHandler = (values) => {
        navigate(`/dashboard/blog-post/edit/${values.id}`)
    }
    const deleteHandler = (value) => {
        console.log("I am delete", value)

        dispatch(DeleteLeadType(value.id))
            .then((response) => {
                if (response.meta.requestStatus === "fulfilled") {
                    dispatch(GetBlogPosts())
                }

            })
            .catch((error) => { errorNotify(error) })
    }

    const addBlogPostHandler = () => {
        navigate('/dashboard/blog-post/add')
    }



    return (
        <>
            <section className='flex-grow-1 property-types'>
                <div className='property-listing-header my-4 px-4 d-flex align-items-center gap-3'>
                    <h3 className='m-0'>Blog Posts</h3>
                    <Button onClick={addBlogPostHandler}><FaPlus color='#fff' size={20} /></Button>
                </div>

                {
                    isLoading ? <div className='h-100 d-flex justify-content-center align-items-center'>
                        <MapLoader />
                    </div> : (
                        <div className="property-listing-grid mt-5">
                            <Row className='justify-content-center'>
                                <Col lg={11}>
                                    {/* <DataGridGlobal rows={rows} columns={columns} pageSize={pageSize} /> */}
                                    <DataGridGlobal
                                        data={blogPosts?.length ? blogPosts : []}
                                        columns={columns}
                                        options={options}
                                    />
                                </Col>
                            </Row>
                        </div>
                    )
                }
            </section>
            <ModalGlobal>
                <AddLeadType isEdit={isEdit} data={document} />
            </ModalGlobal>

        </>

    )
}

export default LeadTypes