import { Col, Row } from 'react-bootstrap'
import { ButtonComp, InputComp } from '../../bootstrap'
import { useModal } from '../../../hooks/useModal'
import { AddBlogCategory, AddPropertyLeadSource, AddPropertyTypes, EditBlogCategory, EditLeadSource, EditPropertyType, GetCategories, GetPropertyTypes } from '../../../store/slices/propertyManagementSlice/propertyManagementSlice'
import { useEffect, useState } from 'react'
import { useDispatch } from 'react-redux'
import { errorNotify } from '../../../Toastify/Toastify'

const AddSource = ({ isEdit, data, setIsEdit }) => {
    const { handleModalClose } = useModal()
    const dispatch = useDispatch();
    const [categoryName, setCategoryName] = useState("")
    const [slug, setSlug] = useState("")

    useEffect(() => {
        if (isEdit) {
            setCategoryName(data.name)
            setSlug(data.slug)
        }
    }, [isEdit])

    const addPropertyTypeHandler = (e) => {
        e.preventDefault()

        if (!categoryName || !slug) {
            errorNotify("Required Fields are missing !")
            return
        }

        const payload = {
            name: categoryName,
            slug: slug
        }

        if (!isEdit) {
            dispatch(AddBlogCategory(payload))
                .unwrap()
                .then(() => {
                    handleModalClose()
                    dispatch(GetCategories())
                })
                .catch((error) => {
                    errorNotify(error)
                })

        } else {
            dispatch(EditBlogCategory({ param: data.id, payload }))
                .unwrap()
                .then(() => {
                    handleModalClose()
                    setIsEdit(false)
                    dispatch(GetCategories())
                })
                .catch((error) => {
                    errorNotify(error)
                })

        }


    }


    return (
        <fieldset className="reset mt-3 p-4 pt-0 t-0 ">
            <legend className="reset mb-3 side-heading px-5 mx-auto">{isEdit ? 'Update' : 'Add'} Category</legend>
            <form onSubmit={addPropertyTypeHandler} >
                <Row className='mt-3'>
                    <Col xxl={12} className="">
                        <Row>
                            <Col lg={6} className='bg-lightgray p-3'>
                                <h5 className='pb-3'>{isEdit ? 'Update' : 'Add'} Category Name</h5>
                                <div className='property-no'>
                                    <InputComp onChange={(e) => setCategoryName(e.target.value)} required={true} label={"Enter Category Name: *"} type={"text"} placeholder={"Category Name"} controlId={"floatingInput-3"} name="PropertyNo" value={categoryName} />
                                </div>
                            </Col>
                            <Col lg={6} className='bg-lightgray p-3'>
                                <h5 className='pb-3'>{isEdit ? 'Update' : 'Add'} Slug</h5>
                                <div className='property-no'>
                                    <InputComp onChange={(e) => setSlug(e.target.value)} required={true} label={"Enter Slug: *"} type={"text"} placeholder={"Slug"} controlId={"floatingInput-3"} name="PropertyNo" value={slug} />
                                </div>
                            </Col>

                        </Row>
                        <Row>
                            <Col lg={12} className=' mt-5'>
                                <ButtonComp type="submit" variant={"outline-primary"} className="btn-main-clr text-white" btnText={isEdit ? 'Update Category' : 'Add Category'} onClick={addPropertyTypeHandler} />
                            </Col>
                        </Row>
                    </Col>
                </Row>
            </form>
        </fieldset>
    )
}

export default AddSource