import { Col, Row } from 'react-bootstrap'
import { ButtonComp, InputComp } from '../../bootstrap'
import { useModal } from '../../../hooks/useModal'
import { useEffect, useState } from 'react'
import { useDispatch } from 'react-redux'
import { errorNotify, successNotify } from '../../../Toastify/Toastify'
import axios from 'axios'
import { BASE_URL } from '../../../config/service'
import { GetAllServicesTabs } from '../../../store/slices/propertyManagementSlice/propertyManagementSlice'
import WebDevServiceForm from '../../ServicesForms/WebDevServiceForm'
import BrandAgencyServiceForm from '../../ServicesForms/BrandAgencyServiceForm'
import ApplicationDevServiceForm from '../../ServicesForms/ApplicationDevServiceForm'
import GraphicDesignServiceForm from '../../ServicesForms/GraphicDesignServiceForm'
import SoftwareDevServiceForm from '../../ServicesForms/SoftwareDevServiceForm'
import WebsiteDesignServiceForm from '../../ServicesForms/WebsiteDesignServiceForm'
import VirtualEmployServiceForm from '../../ServicesForms/VirtualEmployServiceForm'
import ReputationManagementServiceForm from '../../ServicesForms/ReputationManagementServiceForm'
import InternetMarketingServiceForm from '../../ServicesForms/InternetMarkettingServiceForm'
import ListingServiceForm from '../../ServicesForms/ListingServiceForm'
import ContentMarketingServiceForm from '../../ServicesForms/ContentMarkettingServiceForm'
import EmailMarketingServiceForm from '../../ServicesForms/EmailMarkettingServiceForm'
import SearchEngineMarketingServiceForm from '../../ServicesForms/SearchEngineMarkettingServiceForm'
import EcommerceMarketingServiceForm from '../../ServicesForms/EcommerceMarkettingServiceForm'
import SocialMediaMarketingServiceForm from '../../ServicesForms/SocialMediaMarkettingServiceForm'
import SeoServiceForm from '../../ServicesForms/SeoServiceForm'
import DigitalMarkettingServiceForm from '../../ServicesForms/DigitalMarkettingServiceForm'
import {
  Box,
  TextField,
  Autocomplete,
  Typography,
  Paper
} from '@mui/material'

const AddServicePage = ({ isEdit, data, setIsEdit, onSuccess, handleModalClose }) => {
    console.log('data', data)
    const [selectedTemplate, setSelectedTemplate] = useState('')
    const [searchQuery, setSearchQuery] = useState('')
    const [formData, setFormData] = useState(null)
    const [loading, setLoading] = useState(false)

    const templateOptions = [
        { value: 'web-development', label: 'Web Development Templates', component: WebDevServiceForm },
        { value: 'brand-agency', label: 'Brand Agency Template', component: BrandAgencyServiceForm },
        { value: 'graphic-design', label: 'Graphic Design Template', component: GraphicDesignServiceForm },
        { value: 'software-development', label: 'Software Development Template', component: SoftwareDevServiceForm },
        { value: 'website-design', label: 'Website Design Template', component: WebsiteDesignServiceForm },
        { value: 'application-development', label: 'Application Development Template', component: ApplicationDevServiceForm },
        { value: 'virtual-employ', label: 'Virtual Employ Template', component: VirtualEmployServiceForm },
        { value: 'reputation-management', label: 'Reputation Management Template', component: ReputationManagementServiceForm },
        { value: 'internet-marketing', label: 'Internet Marketing Template', component: InternetMarketingServiceForm },
        { value: 'listing-service', label: 'Listing Service Template', component: ListingServiceForm },
        { value: 'content-marketing', label: 'Content Marketing Template', component: ContentMarketingServiceForm },
        { value: 'email-marketing', label: 'Email Marketing Template', component: EmailMarketingServiceForm },
        { value: 'search-engine-marketing', label: 'Search Engine Marketing Template', component: SearchEngineMarketingServiceForm },
        { value: 'ecommerce-marketing', label: 'Ecommerce Marketing Template', component: EcommerceMarketingServiceForm },
        { value: 'social-media-marketing', label: 'Social Media Marketing Template', component: SocialMediaMarketingServiceForm },
        { value: 'seo-service', label: 'SEO Service Template', component: SeoServiceForm },
        { value: 'digital-marketing', label: 'Digital Marketing Template', component: DigitalMarkettingServiceForm }
    ]

    // Auto-select template and fetch form data when in edit mode
    useEffect(() => {
        if (isEdit && data && data.template_value) {
            // Auto-select the template based on template_value
            setSelectedTemplate(data.template_value)
            
            // Fetch form data using route_url
            fetchFormData(data.route_url)
        }
    }, [isEdit, data])

    const fetchFormData = async (routeUrl) => {
        if (!routeUrl) return
        
        setLoading(true)
        try {
            const token = localStorage.getItem('token');
            const headers = {
                'Content-Type': 'application/json',
                ...(token && { 'Authorization': `Bearer ${token}` })
            };
            
            const response = await axios.get(`${BASE_URL}/${routeUrl}`, { headers });
            
            if (response.data.success) {
                setFormData(response.data.data)
            } else {
                errorNotify('Failed to fetch form data')
            }
        } catch (error) {
            console.error('Error fetching form data:', error)
            errorNotify('Error fetching form data')
        } finally {
            setLoading(false)
        }
    }

    const renderSelectedForm = () => {
        const selectedOption = templateOptions.find(option => option.value === selectedTemplate)
        if (selectedOption && selectedOption.component) {
            const FormComponent = selectedOption.component
            return (
                <FormComponent 
                    isEdit={isEdit}
                    initialData={formData}
                    onSuccess={onSuccess}
                    handleModalClose={handleModalClose}
                    setIsEdit={setIsEdit}
                />
            )
        }
        return null
    }

    const handleTemplateChange = (event, newValue) => {
        if (newValue) {
            setSelectedTemplate(newValue.value)
            // Clear form data when template changes
            setFormData(null)
        } else {
            setSelectedTemplate('')
            setFormData(null)
        }
    }

    return (
        <fieldset className="reset mt-3 p-4 pt-0 t-0 ">
            <legend className="reset mb-3 side-heading px-5 mx-auto">{isEdit ? 'Update' : 'Add'} Service Page</legend>
            
            {/* Template Selection Dropdown */}
            <Row className="mb-4">
                <Col md={6}>
                    <label className="form-label">Select Template</label>
                    <Autocomplete
                        options={templateOptions}
                        getOptionLabel={(option) => option.label}
                        value={templateOptions.find(option => option.value === selectedTemplate) || null}
                        onChange={handleTemplateChange}
                        disabled={isEdit} // Disable template selection in edit mode
                        renderInput={(params) => (
                            <TextField
                                {...params}
                                placeholder="Search and choose a template..."
                                variant="outlined"
                                size="small"
                                sx={{
                                    '& .MuiOutlinedInput-root': {
                                        backgroundColor: 'white',
                                        '&:hover': {
                                            backgroundColor: 'white',
                                        },
                                        '&.Mui-focused': {
                                            backgroundColor: 'white',
                                        }
                                    }
                                }}
                            />
                        )}
                        renderOption={(props, option) => (
                            <Box component="li" {...props}>
                                <Typography variant="body2">
                                    {option.label}
                                </Typography>
                            </Box>
                        )}
                        isOptionEqualToValue={(option, value) => option.value === value.value}
                        noOptionsText="No templates found"
                        clearOnBlur={false}
                        blurOnSelect={true}
                        sx={{
                            '& .MuiAutocomplete-popupIndicator': {
                                transform: 'none'
                            }
                        }}
                    />
                </Col>
            </Row>

            {/* Loading indicator */}
            {loading && (
                <div className="text-center mb-4">
                    <div className="spinner-border" role="status">
                        <span className="visually-hidden">Loading...</span>
                    </div>
                </div>
            )}

            {/* Render Selected Form */}
            {selectedTemplate && !loading && (
                <div className="mt-4">
                    {renderSelectedForm()}
                </div>
            )}
        </fieldset>
    )
}

export default AddServicePage