import Button from 'react-bootstrap/Button';
import Form from 'react-bootstrap/Form';
import { Container, Row, Col } from "react-bootstrap"
import {
    successNotify,
    errorNotify,
} from "../../../Toastify/Toastify"
import "./Login.css"
import { useState } from 'react';
import Loader from '../../Loader/Loader';
import { Link, useNavigate } from 'react-router-dom';
import { BiSolidUser } from "react-icons/bi"
import { RiLockPasswordFill } from "react-icons/ri"
import { BiSolidShow } from "react-icons/bi"      // show password
import { BiSolidHide } from "react-icons/bi"      // hide password
import LOGO from "../../../assets/img/dummy-logo.png"
import { useDispatch, useSelector } from 'react-redux';
import {  SignUpAction } from '../../../store/slices/authSlice/authSlice';
import { MdEmail } from "react-icons/md";




const SignUp = () => {
    const dispatch = useDispatch()
    const { isLoading } = useSelector((state) => state.AuthReducer)

    const navigate = useNavigate()
    const [isPasswordShow, setIsPasswordShow] = useState(false)

    const [formData, setFormData] = useState({
        name: "",
        email: "",
        password: ""
    })

    const handleChange = (e) => {
        const { name, value } = e.target;
        setFormData({
            ...formData,
            [name]: value
        })
    }

    // login handler
    const signUpHandler = async (e) => {
        e.preventDefault()
        const { name, email, password } = formData
        if (!name || !email || !password && password.length < 8) {
            errorNotify('Required Fields are missing ❗')
            return
        } else {
            console.log(email, password);

            const payload = {
                username:name,
                email,
                password,
            }

            dispatch(SignUpAction(payload))
                .unwrap()
                .then((response) => {
                    console.log(response);
                    successNotify("SignUp Successfully ! 🔓")
                    navigate("/")
                    
                })
                .catch((err) => {
                    console.log("catch is running ", err)
                    errorNotify(err)
                })
        }
    }

    // show hide password
    const passwordShowHideHandler = () => {
        setIsPasswordShow(!isPasswordShow)
    }
    return (
        <>
            {
                isLoading ? <Loader /> : (
                    <Container fluid className='h-100 d-flex flex-column justify-content-center'>
                        <Row className='login-section'>
                            <Col xl={4} lg={5} md={6} >
                                <div className="text- dark login-form-container">
                                    <div>
                                        <div className="company-logo d-flex flex-column align-items-center">
                                            <div className='mb-2'>
                                                <img src={LOGO} alt="logo" />
                                            </div>
                                        </div>

                                    </div>


                                    <Form className='form login-form' onSubmit={signUpHandler}>
                                        <div className='form-heading mb-4'>
                                            <h2 className='fw-700 m-0'>Register</h2>
                                            <div className='m-0 mt-3'>Create New Account</div>
                                        </div>
                                        <Form.Group className="mb-3 icon-input" controlId="formBasicName">
                                            <BiSolidUser size={20} color='#16BFBF' />
                                            <Form.Control type="text" placeholder="Username" name='name' value={formData.name} onChange={handleChange} />
                                        </Form.Group>

                                        <Form.Group className="mb-3 icon-input" controlId="formBasicEmail">
                                            <MdEmail size={20} color='#16BFBF' />
                                            <Form.Control type="email" placeholder="Email" name='email' value={formData.email} onChange={handleChange} />
                                        </Form.Group>

                                        <Form.Group className="mb-3 icon-input" controlId="formBasicPassword">
                                            <RiLockPasswordFill size={20} color='#16BFBF' />
                                            {
                                                !isPasswordShow ? <BiSolidHide onClick={passwordShowHideHandler} size={20} color='#16BFBF' className='password-show-hide' /> : <BiSolidShow onClick={passwordShowHideHandler} size={20} color='#E8090C' className='password-show-hide' />
                                            }


                                            <Form.Control type={isPasswordShow ? "text" : "password"} placeholder="Password" name='password' value={formData.password} onChange={handleChange} />
                                        </Form.Group>

                                        <Button variant="" type="submit" className='text-center w-100 bg-main-clr text-white fw-700'>
                                            Register
                                        </Button>
                                        <div className='mt-3'>
                                            <span className=''>Already have an account ? <Link className='fw-bold' to={"/"}>Sign In Instead</Link></span>
                                        </div>
                                    </Form>

                                </div>
                            </Col>
                            <Col xl={8} lg={7} md={6} className='pe-md-0 d-sm-block d-none'  >
                                <div className='login-form-bg'></div>
                            </Col>
                        </Row>
                    </Container>
                )
            }
        </>
    );
}

export default SignUp;



{/* <div className='login-form-footer mb-3 d-flex justify-content-between align-align-items-center'>
    <div className='remember-pass'>
        <input type="checkbox" id="rememberPassword" name="rememberPassword" value="rememberPassword" />
        <label htmlFor="rememberPassword" className=''>Remember Password</label>
    </div>
    <div className='forgot-pass'>
        <span>Forgot Password</span>
    </div>
</div> */}