import * as React from 'react';
import { styled } from '@mui/material/styles';
import ArrowForwardIosSharpIcon from '@mui/icons-material/ArrowForwardIosSharp';
import MuiAccordion from '@mui/material/Accordion';
import MuiAccordionSummary from '@mui/material/AccordionSummary';
import MuiAccordionDetails from '@mui/material/AccordionDetails';
import Typography from '@mui/material/Typography';
import { Link, useLocation } from 'react-router-dom';
import { FaRegUser } from "react-icons/fa6";
import { FaUserPen } from "react-icons/fa6";
import { IoIosDocument } from "react-icons/io";
import { FaFolderTree } from "react-icons/fa6";
import { HiMiniQuestionMarkCircle } from "react-icons/hi2";
import { CgFileDocument } from "react-icons/cg";
import { TfiPencilAlt } from "react-icons/tfi";
import "./Accordian.css"
import { SideBarContext } from '../../context/SideBarContext';
import { PiGlobeBold } from "react-icons/pi";
import { RiPagesLine } from "react-icons/ri";
import { MdScreenshotMonitor } from "react-icons/md";
import { GrAchievement } from "react-icons/gr";
import { GiAchievement } from "react-icons/gi";
import { GoScreenFull } from "react-icons/go";
import { MdOutlineMedicalServices } from "react-icons/md";
import { MdMiscellaneousServices } from "react-icons/md";
import { FaUserCheck } from "react-icons/fa";
import { RiListSettingsLine } from "react-icons/ri";
import { RiShieldUserFill } from "react-icons/ri";
import { MdDisplaySettings } from "react-icons/md";













const Accordion = styled((props) => (
    <MuiAccordion disableGutters elevation={0} square {...props} />
))(({ theme }) => ({
    background: 'transparent'
}));

const AccordionSummary = styled((props) => (
    <MuiAccordionSummary
        expandIcon={<ArrowForwardIosSharpIcon sx={{ fontSize: '0.9rem' }} />}
        {...props}
    />
))(({ theme }) => ({
    alignItems: 'center',

    flexDirection: 'row',
    '& .MuiAccordionSummary-expandIconWrapper.Mui-expanded': {
        transform: 'rotate(90deg)',
    },
    '& .MuiAccordionSummary-content': {
        marginLeft: theme.spacing(1),

    }

}));

const AccordionDetails = styled(MuiAccordionDetails)(({ theme }) => ({
}));

export default function CustomizedAccordions({ nav }) {
    const { showSideBar } = React.useContext(SideBarContext)
    const { pathname } = useLocation();
    const { summary, isDropdown, details, type, path, id } = nav

    const openClosedAccordian = [
        "Blogs Management",
        "User Management",
        "FAQ",
        "Home Page",
        "Service Management",
    ]
    const [expanded, setExpanded] = React.useState(['panel1', 'panel2']);

    const handleChange = (panel, summary) => (event, newExpanded) => {

        if (openClosedAccordian.includes(summary)) {    // for open and close accordian) {
            setExpanded(newExpanded ? [panel] : false);
        }


    };

    const mainIconMap = {
        "Blogs Management": <CgFileDocument size={19} className='me-3' />,
        "User Management": <RiShieldUserFill size={19} className='me-3' />,
        "FAQ": <HiMiniQuestionMarkCircle size={19} className='me-3' />,
        "Home Page": <PiGlobeBold  size={19} className='me-3' />,
        "Service Management": <RiListSettingsLine size={19} className='me-3' />,
    };

    const subNavIconMap = {
       
        "Blogs": <IoIosDocument  size={17} className='me-3' />,
        "Blog Categories": <FaFolderTree size={17} className='me-3' />,
        "Blog Post": <TfiPencilAlt  size={17} className='me-3' />,
        "Users": <FaUserCheck size={17} className='me-3' />,
        "Roles": <FaUserPen size={17} className='me-3' />,
        "FAQ": <HiMiniQuestionMarkCircle size={17} className='me-3' />,
        "Home": <RiPagesLine size={17} className='me-3' />,
        "Banners": <MdScreenshotMonitor size={17} className='me-3' />,
        "Achievements": <GrAchievement size={17} className='me-3' />,
        "Promotions": <GiAchievement size={19} className='me-3' />,
        "Reviews": <FaRegUser size={17} className='me-3' />,
        "Our Services": <MdOutlineMedicalServices size={17} className='me-3' />,
        "Services Tabs": <MdMiscellaneousServices size={17} className='me-3' />,
        "Portfolio": <GoScreenFull size={17} className='me-3' />,
        "Services Pages": <MdDisplaySettings size={17} className='me-3' />,
    };


    return (

        <Accordion expanded={expanded && expanded.includes(`panel${id}`)} onChange={handleChange(`panel${id}`, summary)} >
            <AccordionSummary aria-controls={`panel${id}d-content`} id={`panel${id}d-header`} className={`d-flex align-items-center bg-light-gray ${pathname == path ? 'active' : ""}`} >
                {
                    mainIconMap[summary]
                }
                {
                    type === "Route" ? (
                        <Link to={path} onClick={() => { showSideBar(false) }}>
                            <Typography>{summary}</Typography>
                        </Link>
                    ) : <Typography>{summary}</Typography>
                }
            </AccordionSummary>
            {
                isDropdown && (
                    details.map((subNav, index) => (
                        <AccordionDetails key={index} sx={{
                            paddingLeft: '10px',
                            paddingRight: '10px',
                            paddingTop: 0,
                            paddingBottom: 0,
                        }}>
                            <>

                                <AccordionSummary className={pathname == subNav.path ? 'active' : ""} >
                                    {
                                        subNavIconMap[subNav.summary]
                                    }
                                    {
                                        subNav.type === "Route" ? (
                                            <Link to={subNav.path} onClick={() => { showSideBar(false) }}>
                                                <Typography sx={{ fontSize: 14 }}>{subNav.summary}</Typography>
                                            </Link>
                                        ) : <Typography >{subNav.summary}</Typography>
                                    }
                                </AccordionSummary>
                            </>
                        </AccordionDetails>
                    ))
                )
            }

        </Accordion>



    );
}
