const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const seomarketingTemplateModel = sequelize.define(
  "seo_marketing_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    stand_out_section: { type: DataTypes.JSON, allowNull: true },
    our_services_section: { type: DataTypes.JSON, allowNull: true },
    technologies_we_use: { type: DataTypes.JSON, allowNull: true },
    our_experties: { type: DataTypes.JSON, allowNull: true },
    services_cards: { type: DataTypes.JSON, allowNull: true },
    view_profile: { type: DataTypes.JSON, allowNull: true },
    cards: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "seo_marketing_template",
    underscored: true,
    timestamps: true,
  }
);

const seomarketingTemplate = {
  create: async (data) => {
    try {
      const newRecord = await seomarketingTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await seomarketingTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await seomarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await seomarketingTemplateModel.findByPk(id);
      if (!record) return null;

      await seomarketingTemplateModel.update(data, { where: { id } });
      return await seomarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await seomarketingTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { seomarketingTemplate, seomarketingTemplateModel };
