const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const reputationmanagementTemplateModel = sequelize.define(
  "reputation_management_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    stand_out_section: { type: DataTypes.JSON, allowNull: true },
    our_achievements_section: { type: DataTypes.JSON, allowNull: true },
    our_experties_section: { type: DataTypes.JSON, allowNull: true },
    information_card: { type: DataTypes.JSON, allowNull: true },
    portfolio_section: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "reputation_management_template",
    underscored: true,
    timestamps: true,
  }
);

const reputationmanagementTemplate = {
  create: async (data) => {
    try {
      const newRecord = await reputationmanagementTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await reputationmanagementTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await reputationmanagementTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await reputationmanagementTemplateModel.findByPk(id);
      if (!record) return null;

      await reputationmanagementTemplateModel.update(data, { where: { id } });
      return await reputationmanagementTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await reputationmanagementTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { reputationmanagementTemplate, reputationmanagementTemplateModel };
