const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const graphicdesigningTemplateModel = sequelize.define(
  "graphic_designing_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    stand_out_section: { type: DataTypes.JSON, allowNull: true },
    our_achievements_section: { type: DataTypes.JSON, allowNull: true },
    our_services_section: { type: DataTypes.JSON, allowNull: true },
    industries_we_serve_section: { type: DataTypes.JSON, allowNull: true },
    our_top_clients_section: { type: DataTypes.JSON, allowNull: true },
    portfolio_section: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "graphic_designing_template",
    underscored: true,
    timestamps: true,
  }
);

const graphicdesigningTemplate = {
  create: async (data) => {
    try {
      const newRecord = await graphicdesigningTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await graphicdesigningTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await graphicdesigningTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await graphicdesigningTemplateModel.findByPk(id);
      if (!record) return null;

      await graphicdesigningTemplateModel.update(data, { where: { id } });
      return await graphicdesigningTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await graphicdesigningTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { graphicdesigningTemplate, graphicdesigningTemplateModel };
