const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const applicationdevelopmentTemplateModel = sequelize.define(
  "application_development_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    services_tabs_section_image: { type: DataTypes.STRING, allowNull: true },
    services_tabs_section_text: { type: DataTypes.JSON, allowNull: true },
    our_services_section:{ type: DataTypes.JSON, allowNull: true },
    services_tab_section: { type: DataTypes.JSON, allowNull: true },
    all_services_grid:{ type: DataTypes.JSON, allowNull: true },  
    info_cards_section: { type: DataTypes.JSON, allowNull: true },  
    enable_faq:{ type: DataTypes.BOOLEAN, allowNull: true },
    enable_review:{ type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "application_development_template",
    underscored: true,
    timestamps: true, 
  }
);

const applicationdevelopmentTemplate = {
  create: async (data) => {
    try {
      const newRecord = await applicationdevelopmentTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await applicationdevelopmentTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await applicationdevelopmentTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await applicationdevelopmentTemplateModel.findByPk(id);
      if (!record) return null;

      await applicationdevelopmentTemplateModel.update(data, { where: { id } });
      return await applicationdevelopmentTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await applicationdevelopmentTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { applicationdevelopmentTemplate , applicationdevelopmentTemplateModel };
