const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const WebDesignServiceTemplateModel = sequelize.define(
  "web_design_service_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    services_tabs_section_image: { type: DataTypes.STRING, allowNull: true },
    service_section_Tabs: { type: DataTypes.JSON, allowNull: true },
    services_cards: { type: DataTypes.JSON, allowNull: true },
    why_choose_us_section: { type: DataTypes.JSON, allowNull: true },
    info_cards_section: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }

  },
  {
    tableName: "web_design_service_template",
    underscored: true,
    timestamps: true,
  }
);

const WebDesignServiceTemplate = {
  create: async (data) => {
    try {
      const newRecord = await WebDesignServiceTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await WebDesignServiceTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await WebDesignServiceTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await WebDesignServiceTemplateModel.findByPk(id);
      if (!record) return null;

      await WebDesignServiceTemplateModel.update(data, { where: { id } });
      return await WebDesignServiceTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await WebDesignServiceTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { WebDesignServiceTemplate, WebDesignServiceTemplateModel };
