const { DataTypes } = require("sequelize");
const sequelize = require("../../config/sequelize");

const servicesSectionModel = sequelize.define("services_section", {
  main_heading: {
    type: DataTypes.STRING,
    allowNull: false,
  },
}, {
  tableName: "services_section",
  underscored: true,
});

const servicesSection = {
  create: async (data) => {
    try {
      if (!data.main_heading) return { error: "Main heading is required." };
      return await servicesSectionModel.create(data);
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await servicesSectionModel.findAll({ order: [["created_at", "DESC"]] });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await servicesSectionModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await servicesSectionModel.findByPk(id);
      if (!record) return null;
      await servicesSectionModel.update(data, { where: { id } });
      return await servicesSectionModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await servicesSectionModel.destroy({ where: { id } });
      if (!deleted) return null;
      return { message: "Services section deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};

module.exports = { servicesSectionModel, servicesSection };
