const { DataTypes } = require("sequelize");
const sequelize = require("../../config/sequelize");

const service_tab_main_headingModel = sequelize.define("service_tab_main_heading", {
  heading: { type: DataTypes.STRING, allowNull: false },
 
}, {
  tableName: "service_tabs_main_heading",
  underscored: true,
});

const fs = require("fs");
const path = require("path");

const service_tab_main_heading = {
  create: async (data) => {
    if (!data.heading) {
      return { error: "Heading is required." };
    }
    return await service_tab_main_headingModel.create(data);
  },

    getAll: async () => {
      try {
        return await service_tab_main_headingModel.findAll({ order: [["created_at", "DESC"]] });
      } catch (err) {
        throw err;
      }
    },



  getsingle: async (id) => {
    try {
      return await service_tab_main_headingModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update : async (id, data) => {
    try {
      const record = await service_tab_main_headingModel.findByPk(id);
      if (!record) return null;
      await service_tab_main_headingModel.update(data, { where: { id } });
      return await service_tab_main_headingModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },
  delete : async (id) => {
    try {
      const deleted = await service_tab_main_headingModel.destroy({ where: { id } });
      if (!deleted) return null;
      return { message: "Service tab main heading deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },

};

module.exports = { service_tab_main_headingModel, service_tab_main_heading };
