const { DataTypes } = require("sequelize");
const sequelize = require('../../config/sequelize');

const Review = sequelize.define("Review", {
  reviewer_title: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  reviewer_company_name: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  reviewer_service_name: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  review_text: {
    type: DataTypes.TEXT,
    allowNull: false,
  },
  reviewer_thumbnail: {
    type: DataTypes.STRING,
    allowNull: false,
  },
   show_on_home: {
    type: DataTypes.BOOLEAN,
    defaultValue: false,
    allowNull: false,
  },
  pages: {
    type: DataTypes.JSON, 
    allowNull: false,
    defaultValue: []
  }
});

module.exports = Review;
