const { DataTypes } = require("sequelize");
const sequelize = require("../../config/sequelize");

const portfolioItemModel = sequelize.define("portfolio_item", {
  media_url: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  media_alt: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  item_heading: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  item_link: {
    type: DataTypes.STRING,
    allowNull: true,
  },
}, {
  tableName: "portfolio_items",
  underscored: true,
});

module.exports = portfolioItemModel;
