const { DataTypes } = require("sequelize");
const sequelize = require("../../config/sequelize");

const agencySectionModel = sequelize.define(
  "agency_section",
  {
    main_heading_1: { type: DataTypes.STRING, allowNull: false },
    main_heading_2: { type: DataTypes.STRING, allowNull: false },
    content_para_1: { type: DataTypes.TEXT, allowNull: false },
    content_para_2: { type: DataTypes.TEXT, allowNull: false },
  },
  {
    tableName: "agency_sections",
    underscored: true,
  }
);

const agencySection = {
  create: async (data) => {
    try {
      return await agencySectionModel.create(data);
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await agencySectionModel.findAll({ order: [["created_at", "DESC"]] });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await agencySectionModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await agencySectionModel.findByPk(id);
      if (!record) return null;
      await agencySectionModel.update(data, { where: { id } });
      return await agencySectionModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await agencySectionModel.destroy({ where: { id } });
      if (!deleted) return null;
      return { message: "Services section deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};
module.exports = { agencySectionModel , agencySection };
