const { faqModel } = require("../../../models/home/faqModel");
const Review = require("../../../models/home/reviewModel");
require("dotenv").config();
const BASE_URL = process.env.BASE_URL;

const reviews_faq_filterController = {
    filterReviewsByRoute: async (route_url) => {
        if (!route_url) return [];

        try {
            const reviews = await Review.findAll({ order: [["createdAt", "DESC"]] });

            const filtered = reviews.filter((review) => {
                const pages = Array.isArray(review.pages) ? review.pages : JSON.parse(review.pages || "[]");
                return pages.some((page) => page.route_url === route_url);
            });

            const mapped = filtered.map((r) => ({
                ...r.toJSON(),
                reviewer_thumbnail: `${BASE_URL}${r.reviewer_thumbnail}`,
            }));

            return mapped;
        } catch (error) {
            console.error("Filter Reviews Error:", error);
            throw error;
        }
    },

    getReviewsForPage: async (req, res) => {
        try {
            const route_url = req.query.route_url || req.body.route_url;
            if (!route_url) return res.status(400).json({ success: false, message: "route_url is required" });

            const reviews = await reviews_faq_filterController.filterReviewsByRoute(route_url);
            return res.status(200).json({ success: true, data: reviews });
        } catch (err) {
            return res.status(500).json({ success: false, message: "Server Error", error: err.message });
        }
    },






    filterFaqByRoute: async (route_url) => {
        if (!route_url) return [];

        try {
            const faqs = await faqModel.findAll({ order: [["createdAt", "DESC"]] });

            const filtered = faqs.filter((faq) => {
                const pages = Array.isArray(faq.pages)
                    ? faq.pages
                    : JSON.parse(faq.pages || "[]");
                return pages.some((page) => page.route_url === route_url);
            });

            return filtered.map((f) => f.toJSON());
        } catch (error) {
            console.error("Filter FAQ Error:", error);
            throw error;
        }
    },

    // API endpoint style
    // getFaqForPage: async (req, res) => {
    //     try {
    //         const route_url = req.query.route_url || req.body.route_url;
    //         if (!route_url) {
    //             return res
    //                 .status(400)
    //                 .json({ success: false, message: "route_url is required" });
    //         }

    //         const faqs = await reviews_faq_filterController.filterFaqByRoute(route_url);
    //         return res.status(200).json({ success: true, data: faqs });
    //     } catch (err) {
    //         console.error("Get FAQ For Page Error:", err);
    //         return res
    //             .status(500)
    //             .json({ success: false, message: "Server Error", error: err.message });
    //     }
    // },


    getFaqForPage: async (req, res) => {
  try {
    let route_url;

    // Allow calling with (req, res) or with a direct string
    if (typeof req === "string") {
      route_url = req;
    } else {
      route_url = req?.query?.route_url || req?.body?.route_url;
    }

    if (!route_url) {
      if (res) return res.status(400).json({ success: false, message: "route_url is required" });
      return [];
    }

    const faqs = await reviews_faq_filterController.filterFaqByRoute(route_url);

    if (res) return res.status(200).json({ success: true, data: faqs });
    return faqs;

  } catch (err) {
    console.error("Get FAQ For Page Error:", err);
    if (res) {
      return res.status(500).json({ success: false, message: "Server Error", error: err.message });
    }
    throw err;
  }
},







};

module.exports = reviews_faq_filterController;
