const { parse } = require("dotenv");
const {  listingserviceTemplate , listingserviceTemplateModel } = require("../../models/services_templates/listingserviceTemplateModel");
require("dotenv").config();
const reviews_faq_filterController = require("./reviews_faqs_filter/reviews_faq_filterController");




const withBaseUrl = (path) => {
  if (!path) return path;
  if (path.startsWith("http")) return path;
  return `${BASE_URL}${path}`;
};

const parseSafe = (json) => {
  try {
    return typeof json === 'string' ? JSON.parse(json) : json;
  } catch {
    return null;
  }
};

const BASE_URL = process.env.BASE_URL;

const listingserviceTemplateController = {
  createTemplate: async (req, res) => {
    try {
      const newData = await listingserviceTemplateModel.create(req.body);
      return res.status(201).json({
        success: true,
        message: "Listing Service Template created!",
        data: newData,
      });
    } catch (error) {
      console.error("Create Error:", error);
      return res.status(500).json({ success: false, message: "Server Error", error });
    }
  },
getAllTemplates: async (req, res) => {
  try {
    const templates = await listingserviceTemplateModel.findAll({
      order: [["created_at", "DESC"]],
    });

    const parsedTemplates = templates.map(template => {
      const t = template.toJSON();

      const banner = parseSafe(t.banner);
      if (banner?.background_image_url) {
        banner.background_image_url = withBaseUrl(banner.background_image_url);
      }

      const standOut = parseSafe(t.stand_out_section);
      if (standOut?.background_file_url) {
        standOut.background_file_url = withBaseUrl(standOut.background_file_url);
      }
      if (standOut?.image) {
        standOut.image = withBaseUrl(standOut.image);
      }

      const ourServices = parseSafe(t.our_services_section);
      if (ourServices?.section_background) {
        ourServices.section_background = withBaseUrl(ourServices.section_background);
      }
      if (ourServices?.services) {
        ourServices.services = ourServices.services.map(s => ({
          ...s,
          image_url: withBaseUrl(s.image_url),
          sub_services: s.sub_services?.map(sub => ({
            ...sub,
            icon_url: withBaseUrl(sub.icon_url),
          })) || [],
        }));
      }

      const industriesWeServe = parseSafe(t.industries_we_serve_section);
      if (industriesWeServe?.industries) {
        industriesWeServe.industries = industriesWeServe.industries.map(i => ({
          ...i,
          image_url: withBaseUrl(i.image_url),
        }));
      }

      const topClients = parseSafe(t.our_top_clients_section);
      if (topClients?.clients) {
        topClients.clients = topClients.clients.map(client => ({
          ...client,
          image_url: withBaseUrl(client.image_url),
        }));
      }

      const portfolio = parseSafe(t.portfolio_section);
      if (portfolio?.projects) {
        portfolio.projects = portfolio.projects.map(p => ({
          ...p,
          image_url: withBaseUrl(p.image_url),
        }));
      }

      const achievements = parseSafe(t.our_achievements_section);
      if (achievements?.features) {
        achievements.features = achievements.features.map(f => ({
          ...f,
          icon_url: withBaseUrl(f.icon_url),
        }));
      }

      return {
        ...t,
        image: t.image ? withBaseUrl(t.image) : null,
        banner,
        stand_out_section: standOut,
        our_achievements_section: achievements,
        our_services_section: ourServices,
        industries_we_serve_section: industriesWeServe,
        our_top_clients_section: topClients,
        portfolio_section: portfolio,
      };
    });

    return res.status(200).json({ success: true, data: parsedTemplates });
  } catch (error) {
    console.error("Fetch Error:", error);
    return res.status(500).json({ success: false, message: "Server Error", error });
  }
},

getTemplateById: async (req, res) => {
  try {
    const id = req.params.id;
    const template = await listingserviceTemplateModel.findByPk(id);
    if (!template) {
      return res.status(404).json({ success: false, message: "Template not found" });
    }

    const t = template.toJSON();

    const banner = parseSafe(t.banner);
    if (banner?.background_image_url) {
      banner.background_image_url = withBaseUrl(banner.background_image_url);
    }

    const standOut = parseSafe(t.stand_out_section);
    if (standOut?.background_file_url) {
      standOut.background_file_url = withBaseUrl(standOut.background_file_url);
    }
    if (standOut?.image) {
      standOut.image = withBaseUrl(standOut.image);
    }

    const ourServices = parseSafe(t.our_services_section);
    if (ourServices?.section_background) {
      ourServices.section_background = withBaseUrl(ourServices.section_background);
    }
    if (ourServices?.services) {
      ourServices.services = ourServices.services.map(s => ({
        ...s,
        image_url: withBaseUrl(s.image_url),
        sub_services: s.sub_services?.map(sub => ({
          ...sub,
          icon_url: withBaseUrl(sub.icon_url),
        })) || [],
      }));
    }

    const industriesWeServe = parseSafe(t.industries_we_serve_section);
    if (industriesWeServe?.industries) {
      industriesWeServe.industries = industriesWeServe.industries.map(i => ({
        ...i,
        image_url: withBaseUrl(i.image_url),
      }));
    }

    const topClients = parseSafe(t.our_top_clients_section);
    if (topClients?.clients) {
      topClients.clients = topClients.clients.map(client => ({
        ...client,
        image_url: withBaseUrl(client.image_url),
      }));
    }

    const portfolio = parseSafe(t.portfolio_section);
    if (portfolio?.projects) {
      portfolio.projects = portfolio.projects.map(p => ({
        ...p,
        image_url: withBaseUrl(p.image_url),
      }));
    }

    const achievements = parseSafe(t.our_achievements_section);
    if (achievements?.features) {
      achievements.features = achievements.features.map(f => ({
        ...f,
        icon_url: withBaseUrl(f.icon_url),
      }));
    }

      const get_reviews_url = `listing-service-template/${id}`;
      const reviews = await reviews_faq_filterController.filterReviewsByRoute(get_reviews_url);

      const get_faqs = `listing-service-template/${id}`;
      const faqs = await reviews_faq_filterController.getFaqForPage(get_faqs);

    const parsed = {
      ...t,
      image: t.image ? withBaseUrl(t.image) : null,
      banner,
      stand_out_section: standOut,
      our_achievements_section: achievements,
      our_services_section: ourServices,
      industries_we_serve_section: industriesWeServe,
      our_top_clients_section: topClients,
      portfolio_section: portfolio,
      reviews: reviews,
      faqs: faqs
      
    };

    return res.status(200).json({ success: true, data: parsed });
  } catch (error) {
    console.error("Get By ID Error:", error);
    return res.status(500).json({ success: false, message: "Server Error", error });
  }
},



  updateTemplate: async (req, res) => {
    try {
      const id = req.params.id;
      const existing = await listingserviceTemplateModel.findByPk(id);
      if (!existing) {
        return res.status(404).json({ success: false, message: "Template not found" });
      }

      await listingserviceTemplateModel.update(req.body, { where: { id } });
      const updated = await listingserviceTemplateModel.findByPk(id);

      return res.status(200).json({
        success: true,
        message: "Listing Template updated!",
        data: updated,
      });
    } catch (error) {
      console.error("Update Error:", error);
      return res.status(500).json({ success: false, message: "Server Error", error });
    }
  },

  deleteTemplate: async (req, res) => {
    try {
      const id = req.params.id;
      const deleted = await listingserviceTemplateModel.destroy({ where: { id } });

      if (!deleted) {
        return res.status(404).json({ success: false, message: "Template not found" });
      }

      return res.status(200).json({
        success: true,
        message: "Template deleted successfully!",
      });
    } catch (error) {
      console.error("Delete Error:", error);
      return res.status(500).json({ success: false, message: "Server Error", error });
    }
  },
};

module.exports = listingserviceTemplateController
