require("dotenv").config();
const sequelize = require("../../config/sequelize");

const BASE_URL = process.env.BASE_URL;

const withBaseUrl = (path) => {
    if (!path) return path;
    if (path.startsWith("http")) return path;
    return `${BASE_URL}${path}`;
};

const pagesInfoController = {
    getAllPagesInfo: async (req, res) => {
        try {

            // Template options with label mapping requested by Ahti
            const templateOptions = [
                { value: 'web-development', label: 'Web Development Templates' },
                { value: 'brand-agency', label: 'Brand Agency Template' },
                { value: 'graphic-design', label: 'Graphic Design Template' },
                { value: 'software-development', label: 'Software Development Template' },
                { value: 'website-design', label: 'Website Design Template' },
                { value: 'application-development', label: 'Application Development Template' },
                { value: 'virtual-employ', label: 'Virtual Employ Template' },
                { value: 'reputation-management', label: 'Reputation Management Template' },
                { value: 'internet-marketing', label: 'Internet Marketing Template' },
                { value: 'listing-service', label: 'Listing Service Template' },
                { value: 'content-marketing', label: 'Content Marketing Template' },
                { value: 'email-marketing', label: 'Email Marketing Template' },
                { value: 'search-engine-marketing', label: 'Search Engine Marketing Template' },
                { value: 'ecommerce-marketing', label: 'Ecommerce Marketing Template' },
                { value: 'social-media-marketing', label: 'Social Media Marketing Template' },
                { value: 'seo-service', label: 'SEO Service Template' },
                { value: 'digital-marketing', label: 'Digital Marketing Template' }
            ];




            const routeMap = {
                webdevelopment_service_template: "web-development-service-template",
                branding_agency_template: "brand-agency-template", 
                graphic_designing_template: "graphic-design-service-template",
                software_development_template: "software-development-service-template",
                web_design_service_template: "website-design-service-template",
                application_development_template: "application-development-service-template",
                virtual_employees_template: "virtual-employees-service-template",
                reputation_management_template: "reputation-management-service-template",
                internet_marketing_template: "internet-marketing-service-template",
                listing_service_template: "listing-service-template",
                content_marketing_template: "content-marketing-service-template",
                email_marketing_template: "email-marketing-service-template",
                search_engine_marketing_template: "search-engine-marketing-service-template",
                ecommerce_marketing_template: "ecommerce-marketing-service-template",
                social_media_marketing_template: "social-media-marketing-service-template",
                seo_marketing_template: "seo-service-template",
                digital_marketing_service_template: "digital-marketing-service-template"
            };



            const unionQueries = Object.keys(routeMap).map(tableName => {
                return `SELECT id, page_heading, created_at, '${tableName}' AS table_name FROM ${tableName}`;
            });

            const [results] = await sequelize.query(unionQueries.join(" UNION ALL "));

            // const finalData = results.map(row => ({
            //     id: row.id,
            //     page_heading: row.page_heading,
            //     table_name: row.table_name,
            //     route_url: `${routeMap[row.table_name]}/${row.id}`
            // }));

            const finalData = results.map(row => {
                const route = routeMap[row.table_name];

              
                const templateValue = templateOptions.find(t => route.startsWith(t.value))?.value || null;

                return {
                    id: row.id,
                    page_heading: row.page_heading,
                    table_name: row.table_name,
                    route_url: `${route}/${row.id}`,
                    template_value: templateValue,
                    created_at: row.created_at
                };
            });



            return res.status(200).json({
                success: true,
                data: finalData
            });
        } catch (error) {
            console.error("Fetch Pages Info Error:", error);
            return res.status(500).json({
                success: false,
                message: "Server Error",
                error
            });
        }
    }
};

module.exports = pagesInfoController;
