const { services } = require("../../models/services/servicesModel");
const uploadDir = "uploads/services_images";

const ServicesController = {
  create: async (req, res) => {
    try {
      const {
        service_label,
        content_heading,
        service_content,
        img_alt,
        is_active,
        show_on_home,
        is_featured,
      } = req.body;

      const data = {
        service_label,
        content_heading,
        service_content,
        img_alt,
        is_active: is_active === "true" || is_active === true,
        show_on_home: show_on_home === "true" || show_on_home === true,
        is_featured: is_featured === "true" || is_featured === true,
      };

      if (req.file) {
        data.service_img = `/${uploadDir}/${req.file.filename}`;
      }

      const result = await services.create(data);
      if (result?.error) {
        return res.status(400).json({ success: false, message: result.error });
      }

      res.status(201).json({ success: true, message: "Service created!", data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  getAll: async (req, res) => {
    try {
      const result = await services.getAll();
      res.status(200).json({ success: true, data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  getSingle: async (req, res) => {
    try {
      const result = await services.getSingle(req.params.id);
      if (!result) {
        return res.status(404).json({ success: false, message: "Service not found" });
      }
      res.status(200).json({ success: true, data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  update: async (req, res) => {
    try {
      const {
        service_label,
        content_heading,
        service_content,
        img_alt,
        is_active,
        show_on_home,
        is_featured,
      } = req.body;

      const data = {
        service_label,
        content_heading,
        service_content,
        img_alt,
        is_active: is_active === "true" || is_active === true,
        show_on_home: show_on_home === "true" || show_on_home === true,
        is_featured: is_featured === "true" || is_featured === true,

      };

      if (req.file) {
        data.service_img = `/${uploadDir}/${req.file.filename}`;
      }

      const updated = await services.update(req.params.id, data);
      if (!updated) {
        return res.status(404).json({ success: false, message: "Service not found" });
      }

      res.status(200).json({ success: true, message: "Service updated!", data: updated });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  delete: async (req, res) => {
    try {
      const deleted = await services.delete(req.params.id);
      if (!deleted) {
        return res.status(404).json({ success: false, message: "Service not found" });
      }
      res.status(200).json({ success: true, ...deleted });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },
};

module.exports = ServicesController;
