const { reviews_headingModel, reviews_heading  } = require("../../models/home/reviews_headingModel");

const reviews_headingController = {
  create: async (req, res) => {
  try {
    const { heading } = req.body;

    const data = { heading: heading?.trim() };
    const result = await reviews_heading.create(data);

    if (result?.error) {
      return res.status(400).json({ success: false, message: result.error });
    }

    res.status(201).json({
      success: true,
      message: "Services section created successfully!",
      data: result,
    });
  } catch (err) {
    res.status(500).json({ success: false, message: err.message });
  }
},

  getAll: async (req, res) => {
    try {
      const result = await reviews_heading.getAll();
      if (!result.length) {
        return res.status(404).json({ success: false, message: "No section heading found." });
      }
      res.status(200).json({ success: true, data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  getSingle: async (req, res) => {
    try {
      const entry = await reviews_heading.getsingle(req.params.id);
      if (!entry) {
        return res.status(404).json({ success: false, message: "Heading not found." });
      }
      res.status(200).json({ success: true, data: entry });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  update: async (req, res) => {
    try {
      const { heading } = req.body;
      const data = { heading: heading?.trim() };

      const updated = await reviews_heading.update(req.params.id, data);
      if (!updated) {
        return res.status(404).json({ success: false, message: "Heading not found." });
      }

      res.status(200).json({ success: true, message: "Heading updated!", data: updated });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  delete: async (req, res) => {
    try {
      const deleted = await reviews_heading.delete(req.params.id);
      if (!deleted) {
        return res.status(404).json({ success: false, message: "Heading not found." });
      }
      res.status(200).json({ success: true, ...deleted });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },
};

module.exports = reviews_headingController;
